function VOL_t=EST_BA(name,VOL_t)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function EST_BA laskee tilavuuden kpit ja PPA:n avulla kuvitteellisen
% look-up-tablen avulla.             
%
% kunnollisessa proseduurissa sek keskipituus ett pohjapinta-ala
% pit kalibroida, nyt ne vain tempastiin datasta.
%
% Copyright Juha Hyypp 5.3.2006
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%      

eval(['load ',name,'.txt'])
file=eval(name);
eval(['load ',name])

taimikko=[      2  4   6   8  10  12  14  16  18  20  22  24  26  28  30
                4  12  15  18  21  24  27  30  33  36  39  42  45  48  51
                6  18  23  27  32  37  42  47  52  56  60  64  68  72  76
                8  24  30  36  43  50  57  63  69  74  80  85  90  96 101
               10  30  38  46  54  62  71  79  86  93 100 106 113 120 127
               12  36  45  55  65  75  85  94 103 112 120 128 136 144 152
               14  42  53  64  76  87  99 110 120 130 140 149 158 168 178
               16  48  60  73  86 100 113 126 138 149 160 170 181 192 203
               18  54  68  82  97 112 127 142 155 167 179 191 204 216 228
               20  60  75  91 108 125 142 158 172 186 199 213 226 240 253
               22  66  83 100 119 137 156 174 189 204 219 234 249 264 279
               24  72  90 109 130 150 170 189 206 223 239 255 271 288 304
               26  78  98 118 140 162 184 205 224 242 259 276 294 312 330
               28  84 105 127 151 175 198 221 241 260 279 298 317 336 355
               30  90 113 136 162 187 212 237 258 279 299 319 339 360 380
               32  96 120 145 173 200 227 252 275 298 319 340 362 384 406
               34 102 128 154 184 212 241 268 292 316 339 361 385 408 431
               36 108 135 163 194 225 255 284 310 335 359 383 407 432 456
               38 114 143 172 205 237 269 300 327 353 379 404 430 456 482
               40 120 150 181 215 250 283 316 344 372 399 425 452 480 509];
  
% keskipituuden tempaisu

figure(1);
imagesc(chm);
figure(2);
hist(file(:,3),30);
a=chm>0;
b=chm(a);
[N,bin]=hist(b);
kpit=bin(8)

% pohjapinta_alan tempaisu

pituudet=file(:,3)>2;
puu_hitit=sum(pituudet)/length(file(:,3))
puut=file(pituudet,3);
d_h=hist(puut, [5 10 15 20 25 30])/length(puut);
d_h2=sum(d_h(4:6)+0.5*d_h(3)+0.25*d_h(2)+0.125*d_h(1));

PPA=40*d_h2*kpit/30*puu_hitit*puu_hitit
    
if PPA>4 & PPA<40 & kpit>2 & kpit<30      
   VOL=table2(taimikko,PPA,kpit)     
else
   if PPA<4
      suhd=4/PPA;
      PPA=4;
      VOL=table2(taimikko,PPA,kpit)/suhd
   end
   if PPA>40
      VOL=1000000;
  end   
end

pause
VOL_t=[VOL_t VOL]