Attribute VB_Name = "Module1"
Option Explicit


Public Const TO_RADIANS = 1.74532925199433E-02
Public Const TO_DEGREES = 57.2957795130823

Public Const INSIDE = 1
Public Const OUTSIDE = 0

Rem Define an XY-point
Type Point
 x As Double
 y As Double
End Type

Rem A polyline (polygon, plot borders) is an array of XY points
Public PlotPoly() As Point

Rem Define a tree record
Type Tree
  x As Double    ' butt x
  y As Double    ' butt y
  z As Double    ' butt z
  d13 As Double  ' stem diameter
  h As Double    ' tree height
  Num As Long    ' id
  Sp As Byte     ' species
  Status As Byte ' status; living (11-14) dead (> 20)
  Vol As Double  ' stem volume
End Type
Rem the field measured trees will be stored in an array
Public FieldTrees() As Tree

Type ALS_Point
 GPS_time As Double  ' 8
 Xl As Double        ' 8
 Yl As Double        ' 8
 Zl As Single        ' 4
 omega As Single     ' 4
 phi As Single       ' 4
 kappa As Single     ' 4
 Scan_angle As Single ' 4
 Xf As Double         ' 8
 Yf As Double         ' 8
 Zf As Single         ' 4
 Intf As Single       ' 4
 Rangef As Single     ' 4
 Xs As Double         ' 8
 Ys As Double         ' 8
 Zs As Single         ' 4
 Ints As Single       ' 4
 Rangel As Single     ' 4
End Type ' 100 bytes per pulse

Public Const MAX_ALL_LP = 500000
Public LP() As ALS_Point

Type ALS_Point_H
 GPS_time As Double  ' 8
' Xl As Double        ' 8
' Yl As Double        ' 8
' Zl As Single        ' 4
' omega As Single     ' 4
' phi As Single       ' 4
' kappa As Single     ' 4
 Scan_angle As Single ' 4
 InFirst As Boolean   ' 1
 Xf As Double         ' 8
 Yf As Double         ' 8
 Zf As Single         ' 4
 Hf As Single         ' 4
 Intf As Single       ' 4
 Rangef As Single     ' 4
 InLast As Boolean    ' 1  (We need to separate between returns, oblique views)
 Xs As Double         ' 8
 Ys As Double         ' 8
 Zs As Single         ' 4
 Hs As Single         ' 4
 Ints As Single       ' 4
 Rangel As Single     ' 4
End Type ' 108 bytes per pulse , Hs and Hf are relative to ground elevations (normalized)

Public LPH() As ALS_Point_H

Rem Define a gridcell, which stores just about everything that is needed
Type GridCell
 InsidePoly As Boolean    ' False if this cell is not completely included
 Center As Point          ' center X and Y
 corners(1 To 4) As Point ' Four corner points' XY
 InTrees As Long          ' Number of trees inside
 TreeIn(1 To 85) As Tree  ' Array of trees belonging to this cell; assume 50 is enough
 V As Double              ' stem volume m3/ha
 G As Double              ' basal area m2/ha
 N As Double              ' stem number n7ha
 HGM As Double            ' basal area median height (computed as basal area weighted)
 DGM As Double            ' diameter of basal area meadian tree ( "  mean diameter)
 InLIdar As Long          ' number of pulses; determined by last pulse's XY, in this cell
 InFirst As Long
 InLast As Long
 LPsIn(1 To 700) As ALS_Point_H ' the lidar pulses
 Fp50 As Double    ' height, m of median (> 2 m), 50% percentile
 Fvege As Double   ' Proportion of first pulses > 2 m (hitting vegetation)
 Lhmea As Double   ' mean of last pulses > 2 m
 Lvege As Double   ' Proportion of last pulses > 2 m (hitting vegetation)
 
End Type

Rem Array of Gridcells
Public GridCells() As GridCell

Type height_model
 ncols As Double
 nrows As Double
 xllcorner As Double
 yllcorner As Double
 CellSize As Double
 nodata_value As Double
 filepath As String * 80
End Type

Public Zmodel As height_model
Public ZfXY() As Single


Rem Min and Max of plot polygon X's and Y's
Public MinPlotX As Double, MinPlotY As Double, MaxPlotX As Double, MaxPlotY As Double
Rem Dimensions in X and Y
Public PlotWidthMetric As Double, PlotHeightMetric As Double
Rem Size of the picture-Box used for drawing stuff
Public BoxWidthPix As Long, BoxHeightPix As Long
Rem m/pix scale factor of the maps in Picture1
Public MaximalScale As Double
Rem Allow some left and bottom margin in picture (in pixels)
Public BuffX As Long, BuffY As Long
Rem The spacing of grid cells
Public GridSpacingInMeters As Double
Rem The dimension of the square grd
Public GridWidth As Double
Rem Number of cells
Public TotalCells As Long
Public X_origo As Double, Y_origo As Double, Z_origo As Double
Public X_shift As Double, Y_shift As Double, Z_shift As Double
Public angle As Double


Public Sub indexx(ByVal N As Long, ra() As Single, indx() As Long)

Rem Heapsort from Numerical recipes
Rem indx(1 to N) is an index table, returned
Rem ra(1 to N) is the data to be sorted, left as is.

Dim i As Long, j As Long, l As Long, ir As Long, indxt As Long
Dim q As Single
Dim apu As Integer

On Error GoTo virhe_sort

For j = 1 To N
 indx(j) = j
Next j

l = N / 2 + 1
ir = N

10:
 If (l > 1) Then
  l = l - 1
  indxt = indx(l)
  q = ra(indxt)
 Else
  indxt = indx(ir)
  q = ra(indxt)
  indx(ir) = indx(1)
  ir = ir - 1
   If (ir = 1) Then
    indx(1) = indxt
   Exit Sub
   End If
 End If
i = l
j = l + l
20: If j <= ir Then
     If j < ir Then
      If (ra(indx(j)) < ra(indx(j + 1))) Then j = j + 1
     End If
     If (q < ra(indx(j))) Then
      indx(i) = indx(j)
      i = j
      j = j + j
     Else
     j = ir + 1
     End If
     GoTo 20
    End If
   indx(i) = indxt
   GoTo 10
virhe_sort:
MsgBox ("Error in Heapsort, l is " & l)
End Sub




Public Function InsidePolygon(polygon() As Point, ByVal N As Long, ByRef p As Point) As Long
  Dim counter As Long
  Dim i As Long
  Dim xinters As Double
  Dim p1 As Point, p2 As Point
  p1 = polygon(0)
  For i = 1 To N Step 1
    p2 = polygon(i Mod N)
    If (p.y > MIN(p1.y, p2.y)) Then
      If (p.y <= MAX(p1.y, p2.y)) Then
        If (p.x <= MAX(p1.x, p2.x)) Then
          If (p1.y <> p2.y) Then
            xinters = (p.y - p1.y) * (p2.x - p1.x) / (p2.y - p1.y) + p1.x
            If ((p1.x = p2.x) Or (p.x <= xinters)) Then
              counter = counter + 1
            End If
          End If
        End If
      End If
    End If
    p1 = p2
  Next
  If (counter Mod 2 = 0) Then
    InsidePolygon = OUTSIDE
  Else
    InsidePolygon = INSIDE
  End If
End Function

Public Function MIN(x, y)
   If x < y Then MIN = x Else MIN = y
End Function

Public Function MAX(x, y)
   If x > y Then MAX = x Else MAX = y
End Function

Public Function getheight(ByRef x As Double, y As Double) As Double
 
Dim row As Integer, col As Integer
 
 col = CInt((x - Zmodel.xllcorner) / Zmodel.CellSize)
 row = -Int((Zmodel.yllcorner - y) / Zmodel.CellSize)
 
 If col < 0 Or col > Zmodel.ncols - 1 Or row < 0 Or row > Zmodel.nrows - 1 Then
  MsgBox ("Point falls outside Zmodel!")
  getheight = 0#
  Exit Function
 End If
 
 getheight = ZfXY(col, row)
 Exit Function
End Function
