VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Begin VB.Form Form1 
   Caption         =   "Ohjelma lidar-regressioestimointiin"
   ClientHeight    =   12795
   ClientLeft      =   165
   ClientTop       =   735
   ClientWidth     =   14355
   LinkTopic       =   "Form1"
   ScaleHeight     =   12795
   ScaleWidth      =   14355
   StartUpPosition =   3  'Windows Default
   WindowState     =   2  'Maximized
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   120
      Top             =   3720
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.PictureBox Picture1 
      AutoRedraw      =   -1  'True
      BackColor       =   &H80000009&
      Height          =   9255
      Left            =   3360
      ScaleHeight     =   613
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   493
      TabIndex        =   0
      Top             =   120
      Width           =   7455
   End
   Begin VB.Label Label1 
      Caption         =   "Program status"
      Height          =   255
      Left            =   120
      TabIndex        =   1
      Top             =   0
      Width           =   6135
   End
   Begin VB.Menu File 
      Caption         =   "File"
      Begin VB.Menu Read_DEM 
         Caption         =   "0) Read DEM File"
      End
      Begin VB.Menu Open_Plot_polygon 
         Caption         =   "1) Open plot polygon "
      End
      Begin VB.Menu Open_Plot_TreeFile_and_read_lidar 
         Caption         =   "2) Open plot treefile and read lidar data"
      End
      Begin VB.Menu Define_Grid 
         Caption         =   "3) Define Grid"
      End
      Begin VB.Menu Calculate_Forest_Statistics 
         Caption         =   "4) Calculate Forest statistics"
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Private Sub Calculate_Forest_Statistics_Click()

Rem Now each cell has its trees and lidar points
Rem Lets compute statistics i.e. dependant X-vars for regression estimations of V,G,N,H and D

Dim i As Long, NLabove2 As Long, NFabove2 As Long
Dim Fhmea As Double, Lhmea As Double
Dim Above2FInd As Long, Above2SInd As Long
Dim HFSum As Double, HSSum As Double
Dim HfMax As Double, HSMax As Double, HfMin As Double, HSMin As Double
Dim Fp05 As Double, Fp10 As Double, Fp20 As Double, Fp30 As Double, Fp40 As Double, Fp50 As Double
Dim Fp60 As Double, Fp70 As Double, Fp80 As Double, Fp90 As Double, Fp95 As Double
Dim Fsu05 As Double, Fsu10 As Double, Fsu20 As Double, Fsu30 As Double, Fsu40 As Double, Fsu50 As Double
Dim Fsu60 As Double, Fsu70 As Double, Fsu80 As Double, Fsu90 As Double, Fsu95 As Double
Dim Lp05 As Double, Lp10 As Double, Lp20 As Double, Lp30 As Double, Lp40 As Double, Lp50 As Double
Dim Lp60 As Double, Lp70 As Double, Lp80 As Double, Lp90 As Double, Lp95 As Double
Dim Lsu05 As Double, Lsu10 As Double, Lsu20 As Double, Lsu30 As Double, Lsu40 As Double, Lsu50 As Double
Dim Lsu60 As Double, Lsu70 As Double, Lsu80 As Double, Lsu90 As Double, Lsu95 As Double
Dim Ssum2 As Double, Fsum2 As Double
Dim Fvari As Double, Lvari As Double
Dim Dgsum As Double, Volref As Double, Gref As Double, Treesabove5 As Long, Hgsum As Double
Dim FVariance As Double, SVariance As Double
Dim mx As Long, nx As Long

Label1.Caption = "Sorting normalized heights and computing percentiles..."
DoEvents

Rem This table Perc() hold the eleven wanted percentiles
ReDim Perc(11) As Double
Perc(1) = 0.05: Perc(2) = 0.1: Perc(3) = 0.2: Perc(4) = 0.3: Perc(5) = 0.4: Perc(6) = 0.5
Perc(7) = 0.6: Perc(8) = 0.7: Perc(9) = 0.8: Perc(10) = 0.9: Perc(11) = 0.95

Close (5)
Open "c:\data\Regression_results.txt" For Output As 5
Dim capu As String

Rem we process all grid cells; but only those inside deserve a closer look

   Open "C:\Data\AKille_Xvars_" & i & ".txt" For Output As 103
   Open "C:\Data\AKille_Pulses" & i & ".txt" For Output As 101

For i = 1 To TotalCells
  Rem Check if this Cell was inside or not; then perform calculations of lidar features
  If GridCells(i).InsidePoly = True Then
  
  
   Rem We need tables that strore the normalized heights of first (f) and last (s) returns/echoes
   
   ReDim HFtau(1 To GridCells(i).InFirst) As Single
   ReDim HFInd(1 To GridCells(i).InFirst) As Long
   ReDim HStau(1 To GridCells(i).InLast) As Single
   ReDim HSInd(1 To GridCells(i).InLast) As Long
   
   
   Rem Lets use same notation as in Metstieteen aikakausikirja 4/2005 pp. 413-428
   Rem Fhmea arithmetic mean of normalized heights | (> 2 m) of first pulses
   Rem Lhmea arithmetic mean of normalized heights | (> 2 m) of second (last) pulses
   
   Fhmea = 0:   Lhmea = 0:    NLabove2 = 0:  NFabove2 = 0
   Fsum2 = 0:   Ssum2 = 0
   mx = 0: nx = 0
   Rem Fill the arrays and compute mean values, variance
   For j = 1 To GridCells(i).InLIdar
    If GridCells(i).LPsIn(j).InFirst = True Then
     mx = mx + 1
     HFtau(mx) = GridCells(i).LPsIn(j).Hf
       Print #101, i & " " & Format$(GridCells(i).LPsIn(j).Hf, "#.00") & " " & "FP"
     If HFtau(mx) > 2 Then
      Fhmea = Fhmea + HFtau(mx):     NFabove2 = NFabove2 + 1: Fsum2 = Fsum2 + HFtau(mx) ^ 2
     End If
    End If
    
    If GridCells(i).LPsIn(j).InLast = True Then
     nx = nx + 1
     HStau(nx) = GridCells(i).LPsIn(j).Hs
      Print #101, i & " " & Format$(GridCells(i).LPsIn(j).Hs, "#.00") & " " & "LP"
     'Print #102, Format$(GridCells(i).LPsIn(j).Xs, "#.00") & "," & Format$(GridCells(i).LPsIn(j).Ys, "#.00") & "," & Format$(GridCells(i).LPsIn(j).Hs, "#.00")
     If HStau(nx) > 2 Then
      Lhmea = Lhmea + HStau(nx):     NLabove2 = NLabove2 + 1: Ssum2 = Ssum2 + HStau(nx) ^ 2
     End If
    End If
   Next j
   
   Rem Sort the tables for computing the percentiles; use heapsort() that is rather quick in-place algorithm
   Call indexx(CLng(UBound(HFtau)), HFtau, HFInd)
   Call indexx(CLng(UBound(HStau)), HStau, HSInd)
   
   Rem Store the total height sums
   HFSum = Fhmea
   HSSum = Lhmea
   
   Rem Variances of aabove 2 m returns
   FVariance = (NFabove2 * Fsum2 - HFSum ^ 2) / (NFabove2 * (NFabove2 - 1))
   SVariance = (NLabove2 * Ssum2 - HSSum ^ 2) / (NLabove2 * (NLabove2 - 1))
   
   Rem Arithmetic means of first and last pulses (> 2 m)
   Fhmea = Fhmea / NFabove2
   Lhmea = Lhmea / NLabove2
   
'   If Fhmea < Lhmea Then MsgBox ("Your Last returns are higher than first returns!")
   
   
   Rem Coefficients of VAR
   Fvari = Sqr(FVariance) / Fhmea
   Lvari = Sqr(SVariance) / Lhmea
   
  
   Rem Vegetation indeces (0..1); by division
   Fvege = NFabove2 / GridCells(i).InFirst
   Lvege = NLabove2 / GridCells(i).InLast
   
 
   
   Rem Minima and maxima of normalized heights for first and last pulses
   HfMax = HFtau(HFInd(UBound(HFtau)))
   HSMax = HStau(HSInd(UBound(HStau)))
   HfMin = HFtau(HFInd(1))
   HSMin = HStau(HSInd(1))
   
   Rem Find the index of first point with height above 2 m
   Above2FInd = 0
   For m = 1 To GridCells(i).InFirst
    If HFtau(HFInd(m)) > 2 Then
      Above2FInd = m: GoTo CheckHstau
    End If
   Next m
CheckHstau:
   If Above2FInd = 0 Or Above2FInd >= GridCells(i).InLIdar Then MsgBox ("Problem in determining Percentiles!")
   Above2SInd = 0
   For m = 1 To GridCells(i).InLast
    If HStau(HSInd(m)) > 2 Then
      Above2SInd = m: GoTo DoneWithAbove2
    End If
   Next m
DoneWithAbove2:
  
   Rem declare arrays that will hold the distribution function (kertymfunktio), (0...1)
   ReDim HFSumtau(1 To GridCells(i).InFirst) As Single
   ReDim HSSumtau(1 To GridCells(i).InLast) As Single
   Rem Declare arrays that hold the sums associated with the percentiles
   ReDim HfPerc(1 To 11, 1 To 3) As Double
   ReDim HSPerc(1 To 11, 1 To 3) As Double
   For m = 1 To 11
    HfPerc(m, 1) = Perc(m) * HFSum
    HSPerc(m, 1) = Perc(m) * HSSum
   Next m


Rem Sum the heights; get the 11 percentiles of 05, 10, 20, 30, 40, 50, 60, 70, 80, 90 and 95%
   kx = 1
   For m = Above2FInd To GridCells(i).InFirst
     HFSumtau(m) = HFSumtau(m - 1) + HFtau(HFInd(m))
     Rem Check if kx'th percentile is reached
     If HFSumtau(m) >= HfPerc(kx, 1) Then
       Rem Height
       HfPerc(kx, 2) = HFtau(HFInd(m))
       Rem proportion of points
       HfPerc(kx, 3) = ((m - Above2FInd) + 1) / CDbl(GridCells(i).InFirst - Above2FInd + 1)
       kx = kx + 1
       If kx > 11 Then GoTo DoneWithFirstReturnPercentiles
    End If
   Next m
DoneWithFirstReturnPercentiles:
Fp05 = HfPerc(1, 2): Fp10 = HfPerc(2, 2): Fp20 = HfPerc(3, 2): Fp30 = HfPerc(4, 2): Fp40 = HfPerc(5, 2):
Fp50 = HfPerc(6, 2): Fp60 = HfPerc(7, 2): Fp70 = HfPerc(8, 2): Fp80 = HfPerc(9, 2): Fp90 = HfPerc(10, 2):
Fp95 = HfPerc(11, 2):
Fsu05 = HfPerc(1, 3): Fsu10 = HfPerc(2, 3): Fsu20 = HfPerc(3, 3): Fsu30 = HfPerc(4, 3): Fsu40 = HfPerc(5, 3):
Fsu50 = HfPerc(6, 3): Fsu60 = HfPerc(7, 3): Fsu70 = HfPerc(8, 3): Fsu80 = HfPerc(9, 3): Fsu90 = HfPerc(10, 3):
Fsu95 = HfPerc(11, 3):



Rem Last returns
   kx = 1
   For m = Above2SInd To GridCells(i).InLast
     HSSumtau(m) = HSSumtau(m - 1) + HStau(HSInd(m))
     Rem Check if kx'th percentile is reached
     If HSSumtau(m) >= HSPerc(kx, 1) Then
       HSPerc(kx, 2) = HStau(HSInd(m))
       HSPerc(kx, 3) = (m - Above2SInd + 1) / CDbl(GridCells(i).InLast - Above2SInd + 1)
       kx = kx + 1
       If kx > 11 Then GoTo DoneWithLastReturnPercentiles
    End If
   Next m
DoneWithLastReturnPercentiles:
Lp05 = HSPerc(1, 2): Lp10 = HSPerc(2, 2): Lp20 = HSPerc(3, 2): Lp30 = HSPerc(4, 2): Lp40 = HSPerc(5, 2):
Lp50 = HSPerc(6, 2): Lp60 = HSPerc(7, 2): Lp70 = HSPerc(8, 2): Lp80 = HSPerc(9, 2): Lp90 = HSPerc(10, 2):
Lp95 = HSPerc(11, 2):
Lsu05 = HSPerc(1, 3): Lsu10 = HSPerc(2, 3): Lsu20 = HSPerc(3, 3): Lsu30 = HSPerc(4, 3): Lsu40 = HSPerc(5, 3):
Lsu50 = HSPerc(6, 3): Lsu60 = HSPerc(7, 3): Lsu70 = HSPerc(8, 3): Lsu80 = HSPerc(9, 3): Lsu90 = HSPerc(10, 3):
Lsu95 = HSPerc(11, 3):

   capu = capu & Format$(GridCells(i).InFirst, "#") & ","
   capu = capu & Format$(GridCells(i).InLast, "#") & ","
   capu = capu & Format$(NFabove2, "#") & ","
   capu = capu & Format$(NLabove2, "#") & ","
   capu = capu & Format$(Fhmea, "#.00") & ","
   capu = capu & Format$(Lhmea, "#.00") & ","
   capu = capu & Format$(Fvari, "#.00") & ","
   capu = capu & Format$(Lvari, "#.00") & ","
   capu = capu & Format$(Fvege, "#.000") & ","
   capu = capu & Format$(Lvege, "#.000") & ","
   capu = capu & Format$(Fp05, "#.00") & ","
   capu = capu & Format$(Fp10, "#.00") & ","
   capu = capu & Format$(Fp20, "#.00") & ","
   capu = capu & Format$(Fp30, "#.00") & ","
   capu = capu & Format$(Fp40, "#.00") & ","
   capu = capu & Format$(Fp50, "#.00") & ","
   capu = capu & Format$(Fp60, "#.00") & ","
   capu = capu & Format$(Fp70, "#.00") & ","
   capu = capu & Format$(Fp80, "#.00") & ","
   capu = capu & Format$(Fp90, "#.00") & ","
   capu = capu & Format$(Fp95, "#.00") & ","
   capu = capu & Format$(Fsu05, "#.000") & ","
   capu = capu & Format$(Fsu10, "#.000") & ","
   capu = capu & Format$(Fsu20, "#.000") & ","
   capu = capu & Format$(Fsu30, "#.000") & ","
   capu = capu & Format$(Fsu40, "#.000") & ","
   capu = capu & Format$(Fsu50, "#.000") & ","
   capu = capu & Format$(Fsu60, "#.000") & ","
   capu = capu & Format$(Fsu70, "#.000") & ","
   capu = capu & Format$(Fsu80, "#.000") & ","
   capu = capu & Format$(Fsu90, "#.000") & ","
   capu = capu & Format$(Fsu95, "#.000") & ","
   capu = capu & Format$(Lp05, "#.00") & ","
   capu = capu & Format$(Lp10, "#.00") & ","
   capu = capu & Format$(Lp20, "#.00") & ","
   capu = capu & Format$(Lp30, "#.00") & ","
   capu = capu & Format$(Lp40, "#.00") & ","
   capu = capu & Format$(Lp50, "#.00") & ","
   capu = capu & Format$(Lp60, "#.00") & ","
   capu = capu & Format$(Lp70, "#.00") & ","
   capu = capu & Format$(Lp80, "#.00") & ","
   capu = capu & Format$(Lp90, "#.00") & ","
   capu = capu & Format$(Lp95, "#.00") & ","
   capu = capu & Format$(Lsu05, "#.000") & ","
   capu = capu & Format$(Lsu10, "#.000") & ","
   capu = capu & Format$(Lsu20, "#.000") & ","
   capu = capu & Format$(Lsu30, "#.000") & ","
   capu = capu & Format$(Lsu40, "#.000") & ","
   capu = capu & Format$(Lsu50, "#.000") & ","
   capu = capu & Format$(Lsu60, "#.000") & ","
   capu = capu & Format$(Lsu70, "#.000") & ","
   capu = capu & Format$(Lsu80, "#.000") & ","
   capu = capu & Format$(Lsu90, "#.000") & ","
   capu = capu & Format$(Lsu95, "#.000") & ","


Rem regression for Volume
 LNV = 0.788 + 0.704 * Log(Fp50) + 1.09 * Sqr(Fvege) + 0.735 * Log(Lhmea) + 0.267 * Log(Lvege) + (0.02887 + 0.00781) / 2
 Volume = Exp(LNV)
 SQRG = -0.795 + 1.329 * Log(Fhmea) + 1.342 * Fvege + 2.27 * Sqr(Lvege) - 1.773 * (1 / Fp05)
 BasalArea = (SQRG) ^ 2 + (0.13199 + 0.02987)
 N = 11376.75 + 1556.143 * ((Lvege) ^ 2) + 1036.063 * (Fvege ^ 2) - 4.214 * (Lhmea ^ 2) - 5777.637 * (Fsu50 ^ 2) - 5755.064 * (1 / Lsu70) - 1471.856 * Sqr(Lvari)
 SQRHGM = 0.95 + 0.594 * Sqr(Fp80) + 0.055 * Fp60
 HGM = SQRHGM ^ 2 + (0.02877 + 0.00157)
 LNDGM = 2.97 + 0.44 * Sqr(Lp70) - 0.383 * Sqr(Fp20) - 0.337 * (Fvege ^ 2) + 0.409 * Sqr(Fp50) - 1.9 * Sqr(Lsu70) - 0.052 * (1 / Lvege) + (0.01452 + 0.00325) / 2
 DGM = Exp(LNDGM)
   Rem Volume of reference trees
   Volref = 0: Gref = 0: Treesabove5 = 0: Hgsum = 0: Dgsum = 0
   For m = 1 To GridCells(i).InTrees
    Volref = Volref + GridCells(i).TreeIn(m).Vol
    Gref = Gref + GridCells(i).TreeIn(m).d13 ^ 2
    If GridCells(i).TreeIn(m).d13 > 5 Then Treesabove5 = Treesabove5 + 1
    Hgsum = Hgsum + GridCells(i).TreeIn(m).h * (GridCells(i).TreeIn(m).d13) ^ 2
    Dgsum = Dgsum + GridCells(i).TreeIn(m).d13 ^ 3
   Next m
   Hg = Hgsum / Gref
   Dg = Dgsum / Gref
   Gref = (Gref * 3.1415 / 4) * (10000 / (GridWidth * GridWidth)) / 10000
   Volref = Volref * (10000 / (GridWidth * GridWidth)) / 1000
   Nref = Treesabove5 * (10000 / (GridWidth * GridWidth))
 
   capu = capu & Format$(Volume, "#.00") & ","
   capu = capu & Format$(BasalArea, "#.00") & ","
   capu = capu & Format$(N, "#.00") & ","
   capu = capu & Format$(HGM, "#.00") & ","
   capu = capu & Format$(DGM, "#.00") & ","
      
   Print #103, i & "," & capu

   capu = ""
   Print #5, GridCells(i).Center.x, GridCells(i).Center.y, Volume, Volref, Volref - Volume, BasalArea, Gref, Gref - BasalArea, N, Nref, Nref - N, HGM, Hg, Hg - HGM, DGM, Dg, Dg - DGM
'   For j = 1 To GridCells(i).InLIdar
'    xx = Hftau(HfInd(j))
'    xx = HsTau(HfInd(j))
'   Next j
   
           
  End If
Next i
Label1.Caption = "Normalized heights sorted and percentiles computed"
Close (5)
 Close (103):  Close (101): Close (102)

End Sub

Private Sub Define_Grid_Click()

Rem This routine creates a regular grid of XY-points defined by parameter GriDSpacingInMeters;
Rem These points represent centers of grid cells having a size of 0.01-0.03 ha, which is defined by
Rem parameter GridWidth.
Rem
Rem The gid is first laeyd out; then for each grid cell inclusion testeing is performed and only those
Rem cells which are completely indide the forest polygon are accepted for evaluating the lidar-regressions.
Rem (c) Ilkka Korpela 15.3.2006

GridSpacingInMeters = 5
GridWidth = 20#

CellsInXDir = Int((MaxPlotX - MinPlotX) / GridSpacingInMeters + 3)
CellsInYDir = Int((MaxPlotY - MinPlotY) / GridSpacingInMeters + 3)
TotalCells = CellsInXDir * CellsInYDir

ReDim GridCells(1 To TotalCells) As GridCell
Dim corners(1 To 4) As Point ' 1 = lowleft, 2 = upleft, 3 = upright, 4 = lowright
ReDim DX(1 To 4) As Double     ' required shifts with respect to grid center
ReDim DY(1 To 4) As Double
Dim TestPoint As Point
Dim TestPoly(0 To 4) As Point
Dim Bangle As Double
'Picture1.Cls

DX(1) = -GridWidth / 2:  DX(2) = -GridWidth / 2: DX(3) = GridWidth / 2: DX(4) = GridWidth / 2
DY(1) = -GridWidth / 2:  DY(2) = GridWidth / 2: DY(3) = GridWidth / 2: DY(4) = -GridWidth / 2

Rem Rotate these corner-points about center by an angle of angle
For k = 1 To 4
 DXK = DX(k)
 DYK = DY(k)
 DX(k) = Cos(angle) * DXK - Sin(angle) * DYK
 DY(k) = Sin(angle) * DXK + Cos(angle) * DYK
Next k
Rem Start to fill GridCells with data; perform inclusion testing etc.
N = 0
Rem Randomize start point
StartGridX = MinPlotX - 5
StartGridY = MinPlotY - 5
'MinPlotY = MinPlotY + (Rnd() - 0.5) * GridSpacingInMeters / 2

Bangle = angle
If Abs(angle) > 0.5 Then Bangle = 0

For i = 1 To CellsInXDir
  For j = 1 To CellsInYDir
  Rem the grid is left unrotated!
   DXK = (i - 1) * GridSpacingInMeters
   DYK = (j - 1) * GridSpacingInMeters
  
  X_C = StartGridX + DXK * Cos(Bangle) - Sin(Bangle) * DYK
  Y_C = StartGridY + DXK * Sin(Bangle) + Cos(Bangle) * DYK
  N = N + 1
  Label1.Caption = N & " cells processed out of " & TotalCells
  DoEvents
  GridCells(N).Center.x = X_C
  GridCells(N).Center.y = Y_C
   Close (100)
  
 Rem Check if all corners fall inside
  For k = 1 To 4
   GridCells(N).corners(k).x = X_C + DX(k)
   GridCells(N).corners(k).y = Y_C + DY(k)
   INOUT = InsidePolygon(PlotPoly, UBound(PlotPoly), GridCells(N).corners(k))
   If INOUT = OUTSIDE Then
     GridCells(N).InsidePoly = False
     EndX = BuffX + (GridCells(N).Center.x - MinPlotX) * (1 / MaximalScale)
     EndY = (BoxHeightPix - 10) - (GridCells(N).Center.y - MinPlotY) * (1 / MaximalScale)
     Rem Draw a cross
     Picture1.Line (EndX - 3, EndY)-(EndX + 3, EndY), RGB(255, 125, 0)
     Picture1.Line (EndX, EndY - 3)-(EndX, EndY + 3), RGB(255, 125, 0)
     
     GoTo NextCell
   End If
  Next k
  'Exit Sub
  Rem This grid cell is inside the plot polygon
  GridCells(N).InsidePoly = True
  EndX = BuffX + (GridCells(N).Center.x - MinPlotX) * (1 / MaximalScale)
  EndY = (BoxHeightPix - 10) - (GridCells(N).Center.y - MinPlotY) * (1 / MaximalScale)
  Rem Draw a red cross to mark inclusion
   Picture1.Line (EndX - 5, EndY)-(EndX + 5, EndY), RGB(125, 125, 255)
   Picture1.Line (EndX, EndY - 5)-(EndX, EndY + 5), RGB(125, 125, 255)
  Rem Fill testpolygon() i.e. the cell corners (rotated by angle)
   For ix = 1 To 4
     TestPoly(ix - 1).x = GridCells(N).corners(ix).x: TestPoly(ix - 1).y = GridCells(N).corners(ix).y
   Next ix
    TestPoly(4).x = GridCells(N).corners(1).x: TestPoly(4).y = GridCells(N).corners(1).y
  
  StartX = BuffX + (TestPoly(0).x - MinPlotX) * (1 / MaximalScale)
  StartY = (BoxHeightPix - BuffY) - (TestPoly(0).y - MinPlotY) * (1 / MaximalScale)
   For ix = 1 To UBound(TestPoly)
   EndX = BuffX + (TestPoly(ix).x - MinPlotX) * (1 / MaximalScale)
   EndY = (BoxHeightPix - BuffY) - (TestPoly(ix).y - MinPlotY) * (1 / MaximalScale)
    Picture1.Line (StartX, StartY)-(EndX, EndY), RGB(255, 0, 255)
   StartX = EndX
   StartY = EndY
 Next ix
Rem Draw the last line segment back to start
EndX = BuffX + (TestPoly(0).x - MinPlotX) * (1 / MaximalScale)
EndY = (BoxHeightPix - BuffY) - (TestPoly(0).y - MinPlotY) * (1 / MaximalScale)
Picture1.Line (StartX, StartY)-(EndX, EndY), RGB(255, 0, 255)

  
 
  Rem Collect trees for the cell
  
  
  
  Picture1.DrawWidth = 3
  
  For m = 1 To UBound(FieldTrees)
    TestPoint.x = FieldTrees(m).x
    TestPoint.y = FieldTrees(m).y
     INOUT = InsidePolygon(TestPoly, UBound(TestPoly), TestPoint)
      If INOUT = INSIDE Then
       GridCells(N).InTrees = GridCells(N).InTrees + 1
       GridCells(N).TreeIn(GridCells(N).InTrees).x = FieldTrees(m).x
       GridCells(N).TreeIn(GridCells(N).InTrees).y = FieldTrees(m).y
       GridCells(N).TreeIn(GridCells(N).InTrees).z = FieldTrees(m).z
       GridCells(N).TreeIn(GridCells(N).InTrees).d13 = FieldTrees(m).d13
       GridCells(N).TreeIn(GridCells(N).InTrees).h = FieldTrees(m).h
       GridCells(N).TreeIn(GridCells(N).InTrees).Num = FieldTrees(m).Num
       GridCells(N).TreeIn(GridCells(N).InTrees).Sp = FieldTrees(m).Sp
       GridCells(N).TreeIn(GridCells(N).InTrees).Status = FieldTrees(m).Status
       GridCells(N).TreeIn(GridCells(N).InTrees).Vol = FieldTrees(m).Vol
       EndX = BuffX + (FieldTrees(m).x - MinPlotX) * (1 / MaximalScale)
       EndY = (BoxHeightPix - 10) - (FieldTrees(m).y - MinPlotY) * (1 / MaximalScale)
        Picture1.PSet (EndX, EndY), RGB(255, 125, 255)
      End If
  Next m
  Picture1.DrawWidth = 1
  
  Rem Collect lidar points for the cell
   
     
   
   For m = 1 To UBound(LPH)
    Rem Inclusion testing now simply with the last return point
    TestPoint.x = LPH(m).Xs
    TestPoint.y = LPH(m).Ys
     INOUTLAST = InsidePolygon(TestPoly, 4, TestPoint)
    TestPoint.x = LPH(m).Xf
    TestPoint.y = LPH(m).Yf
     INOUTFIRST = InsidePolygon(TestPoly, 4, TestPoint)
      
      If INOUTLAST = INSIDE Or INOUTFIRST = INSIDE Then
       Rem Copy the record; 18 variables
       GridCells(N).InLIdar = GridCells(N).InLIdar + 1
       If INOUTLAST = INSIDE Then
         GridCells(N).InLast = GridCells(N).InLast + 1
         GridCells(N).LPsIn(GridCells(N).InLIdar).InLast = True
       End If
       If INOUTFIRST = INSIDE Then
        GridCells(N).InFirst = GridCells(N).InFirst + 1
        GridCells(N).LPsIn(GridCells(N).InLIdar).InFirst = True
       ' Exit Sub
       End If
       
       GridCells(N).LPsIn(GridCells(N).InLIdar).GPS_time = LPH(m).GPS_time
       GridCells(N).LPsIn(GridCells(N).InLIdar).Intf = LPH(m).Intf
       GridCells(N).LPsIn(GridCells(N).InLIdar).Ints = LPH(m).Ints
       GridCells(N).LPsIn(GridCells(N).InLIdar).Rangef = LPH(m).Rangef
       GridCells(N).LPsIn(GridCells(N).InLIdar).Rangel = LPH(m).Rangel
       Rem See type declaration; in order to get GridCell() entry below 64 k of memory some data are omitted
      ' GridCells(N).LPsIn(GridCells(N).InLIdar).Xl = LPH(m).Xl
      ' GridCells(N).LPsIn(GridCells(N).InLIdar).Yl = LPH(m).Yl
      ' GridCells(N).LPsIn(GridCells(N).InLIdar).Zl = LPH(m).Zl
       GridCells(N).LPsIn(GridCells(N).InLIdar).Xs = LPH(m).Xs
       GridCells(N).LPsIn(GridCells(N).InLIdar).Ys = LPH(m).Ys
       GridCells(N).LPsIn(GridCells(N).InLIdar).Zs = LPH(m).Zs
       GridCells(N).LPsIn(GridCells(N).InLIdar).Xf = LPH(m).Xf
       GridCells(N).LPsIn(GridCells(N).InLIdar).Yf = LPH(m).Yf
       GridCells(N).LPsIn(GridCells(N).InLIdar).Zf = LPH(m).Zf
      ' GridCells(N).LPsIn(GridCells(N).InLIdar).kappa = LPH(m).kappa
      ' GridCells(N).LPsIn(GridCells(N).InLIdar).omega = LPH(m).omega
      ' GridCells(N).LPsIn(GridCells(N).InLIdar).phi = LPH(m).phi
       GridCells(N).LPsIn(GridCells(N).InLIdar).Scan_angle = LPH(m).Scan_angle
       GridCells(N).LPsIn(GridCells(N).InLIdar).Hs = LPH(m).Hs
       GridCells(N).LPsIn(GridCells(N).InLIdar).Hf = LPH(m).Hf
      End If
   Next m
    
NextCell:   Next j
Next i

MsgBox ("Cells now have their trees and lidar points copied! Please proceed with analyses")
End Sub

Private Sub Form_Load()
Picture1.Top = 250
Picture1.Left = 200
Picture1.Height = Form1.Height - 600
Picture1.Width = Form1.Width - 600


End Sub

Private Sub Open_Plot_polygon_Click()

Rem (c) Ilkka Korpela 15.3.2006
Rem This routine reads, stores and draws the polygon borders

CommonDialog1.Filter = "Polygon files (*.txt)|*.txt"
CommonDialog1.DialogTitle = "File which has Plot border XYZ-points"
CommonDialog1.Action = 1
Open CommonDialog1.FileName For Input As 1

ReDim PlotPoly(0 To 200) As Point

Rem Read the polygon, store minima and maxima of X and Y
MinPlotX = 10000000000#
MinPlotY = 10000000000#
MaxPlotX = 0
MaxPlotY = 0
i = 0
Do Until EOF(1)
 Input #1, PlotPoly(i).x, PlotPoly(i).y, dummy
  If PlotPoly(i).x >= MaxPlotX Then MaxPlotX = PlotPoly(i).x
  If PlotPoly(i).y >= MaxPlotY Then MaxPlotY = PlotPoly(i).y
  If PlotPoly(i).x <= MinPlotX Then MinPlotX = PlotPoly(i).x
  If PlotPoly(i).y <= MinPlotY Then MinPlotY = PlotPoly(i).y
 i = i + 1
Loop

Rem Make last point meet first
PlotPoly(i).x = PlotPoly(0).x
PlotPoly(i).y = PlotPoly(0).y

ReDim Preserve PlotPoly(0 To i) As Point
Close (1)

Rem Determine XY-rectangle in which the plot is; allow 1 meter of buffer
PlotWidthMetric = (MaxPlotX - MinPlotX) + 1
PlotHeightMetric = (MaxPlotY - MinPlotY) + 1

Rem Darw the borders using line-method; get first the size of the picture-box (in pixels)
BoxWidthPix = Form1.Picture1.ScaleWidth
BoxHeightPix = Form1.Picture1.ScaleHeight
Rem determine the maximal scale m/pix
MaxScaleInX = PlotWidthMetric / BoxWidthPix
MaxScaleInY = PlotHeightMetric / BoxWidthPix
MaximalScale = MAX(MaxScaleInX, MaxScaleInY) * 1.1
Rem The coordinate system of picture-box is such that the origin is at upper left corner

Rem Draw the polyline
Picture1.Cls
Picture1.CurrentX = 10
Picture1.CurrentY = 10
Picture1.Print CommonDialog1.FileName
Rem Buffers in PIXELS
BuffX = 10
BuffY = 10

Dim StartX As Double, StartY As Double, EndX As Double, EndY As Double
StartX = BuffX + (PlotPoly(0).x - MinPlotX) * (1 / MaximalScale)
StartY = (BoxHeightPix - 10) - (PlotPoly(0).y - MinPlotY) * (1 / MaximalScale)
For i = 1 To UBound(PlotPoly)
 EndX = BuffX + (PlotPoly(i).x - MinPlotX) * (1 / MaximalScale)
 EndY = (BoxHeightPix - 10) - (PlotPoly(i).y - MinPlotY) * (1 / MaximalScale)
 Picture1.Line (StartX, StartY)-(EndX, EndY), RGB(255, 0, 0)
 StartX = EndX
 StartY = EndY
Next i
Rem Draw the last line segment back to start
EndX = BuffX + (PlotPoly(0).x - MinPlotX) * (1 / MaximalScale)
EndY = (BoxHeightPix - BuffY) - (PlotPoly(0).y - MinPlotY) * (1 / MaximalScale)
Picture1.Line (StartX, StartY)-(EndX, EndY), RGB(255, 0, 0)

Rem Draw a horizontal bar of 30 m
Picture1.DrawWidth = 5
For i = 1 To 30
 If i Mod 2 = 0 Then Colorpix = RGB(125, 125, 125)
 If i Mod 2 = 1 Then Colorpix = RGB(0, 0, 0)
 Picture1.Line (20 + (i - 1) * (1 / MaximalScale), 30)-(20 + i * (1 / MaximalScale), 30), Colorpix
Next i

 Picture1.CurrentX = 30
 Picture1.CurrentY = 40
 Picture1.Print "30 m"
 Picture1.DrawWidth = 1



End Sub


Private Sub Open_Plot_TreeFile_and_read_lidar_Click()

CommonDialog1.Filter = "Field data files (*.txt)|*.txt"
CommonDialog1.DialogTitle = "File which has Field data!"
CommonDialog1.Action = 1
Open CommonDialog1.FileName For Input As 1


Label1.Caption = " Reading reference trees..."
DoEvents

Input #1, angle
Input #1, X_origo
Input #1, Y_origo
Input #1, Z_origo
Input #1, X_shift
Input #1, Y_shift
Input #1, Z_shift

angle = angle * TO_RADIANS
i = 0

ReDim FieldTrees(1 To 2500) As Tree

Do Until EOF(1)
 i = i + 1
 Input #1, FieldTrees(i).x, FieldTrees(i).y, FieldTrees(i).z, FieldTrees(i).d13, FieldTrees(i).h, FieldTrees(i).Num, FieldTrees(i).Sp, FieldTrees(i).Status
 
 Rem Depending on how d13 is stored; change code below
  FieldTrees(i).d13 = FieldTrees(i).d13 / 10   ' mm to cm
 'FieldTrees(i).d13 = FieldTrees(i).d13 * 100  ' m to cm
 
 xp = Cos(angle) * FieldTrees(i).x - Sin(angle) * FieldTrees(i).y
 yp = Sin(angle) * FieldTrees(i).x + Cos(angle) * FieldTrees(i).y
 Rem Convert local butt coordinates into 3D object coordinate frame
 FieldTrees(i).x = xp + X_origo + X_shift
 FieldTrees(i).y = yp + Y_origo + Y_shift
 FieldTrees(i).z = FieldTrees(i).z + Z_origo + Z_shift

Loop
Close (1)
Rem Shrink the size of the tree-array
ReDim Preserve FieldTrees(1 To i) As Tree

Label1.Caption = " Drawing tree map..."
DoEvents

Rem Draw trees on the map
For i = 1 To UBound(FieldTrees)
 EndX = BuffX + (FieldTrees(i).x - MinPlotX) * (1 / MaximalScale)
 EndY = (BoxHeightPix - 10) - (FieldTrees(i).y - MinPlotY) * (1 / MaximalScale)
 Rem Define color of point
 Colorpix = RGB(0, 0, 0)
  FieldTrees(i).Vol = 0.022927 * (FieldTrees(i).d13 ^ 1.91505) * (0.99146 ^ FieldTrees(i).d13) * (FieldTrees(i).h ^ 2.82541) * ((FieldTrees(i).h - 1.3) ^ (-1.53547))
'Close (1)
'Exit Sub
 Select Case FieldTrees(i).Sp
  Case 1
  Colorpix = RGB(255, 0, 0)
  FieldTrees(i).Vol = 0.036089 * (FieldTrees(i).d13 ^ 2.01395) * (0.99676 ^ FieldTrees(i).d13) * (FieldTrees(i).h ^ 2.07025) * ((FieldTrees(i).h - 1.3) ^ (-1.07209))
  Case 2
  Colorpix = RGB(0, 255, 0)
  FieldTrees(i).Vol = 0.022927 * (FieldTrees(i).d13 ^ 1.91505) * (0.99146 ^ FieldTrees(i).d13) * (FieldTrees(i).h ^ 2.82541) * ((FieldTrees(i).h - 1.3) ^ (-1.53547))
  Case 3, 4, 5, 6, 7
  Colorpix = RGB(0, 0, 255)
  FieldTrees(i).Vol = 0.011197 * (FieldTrees(i).d13 ^ 2.10253) * (0.986 ^ FieldTrees(i).d13) * (FieldTrees(i).h ^ 3.98519) * ((FieldTrees(i).h - 1.3) ^ (-2.659))
 End Select
 Picture1.FillColor = Colorpix
 Picture1.FillStyle = 0
 Picture1.Circle (EndX, EndY), 1 + (FieldTrees(i).d13 / 100) * (1 / MaximalScale), Colorpix
Next i

Rem Check the one-hectare cells in wihch trees fall in

Dim jx As Long
Dim HectareString(1 To 30) As String * 6
Dim TestString As String * 6
HectareString(1) = Format$(Int((PlotPoly(0).x - 2514000) / 100), "000") & Format$(Int((PlotPoly(0).y - 6855000) / 100), "000")
jx = 1
For i = 1 To UBound(PlotPoly)
  TestString = Format$(Int((PlotPoly(i).x - 2514000) / 100), "000") & Format$(Int((PlotPoly(i).y - 6855000) / 100), "000")
  Found = False
   For j = 1 To jx
    If TestString = HectareString(j) Then
     Found = True
     GoTo NextTree
     Rem We have this hectare allready
     End If
   Next j
  If Found = False Then
  Rem we did not find this one, add it
    jx = jx + 1
    HectareString(jx) = TestString
  End If
NextTree: Next i
  MsgBox ("Lidar data is needed for " & jx & " hectares")
Rem Read and Store LidarPoints in a 9 hectare area around the plot origin
Rem Laser Data is in BIN files 100 by 100 m in each; 9 hecrate can have ca. 270000 pulses if under three strips
Label1.Caption = " Reading " & jx & " hectares of lidar data; plotting some on the map..."
Form1.MousePointer = 11
DoEvents

ReDim aFileName(1 To jx) As String
For k = 1 To jx
  aFileName(k) = "D:\als2004\repros\bin\" & Left(HectareString(k), 3) & "_" & Right(HectareString(k), 3) & ".bin"
Next k

ReDim LP(1 To MAX_ALL_LP) As ALS_Point
Dim Npoints As Long
Dim Mp As Long
Mp = 0
Form1.Picture1.DrawWidth = 7
For k = 1 To jx
  Open aFileName(k) For Binary As 1
  Get #1, , Npoints
  If (Mp + Npoints) > MAX_ALL_LP Then
   MsgBox ("Too many laser points in the 9 ha area!")
   Close (1)
  End If
   For j = 1 To Npoints
     Mp = Mp + 1
     Get #1, 5 + (j - 1) * 100, LP(Mp)
      LP(Mp).Zs = LP(Mp).Zs + 0.18 ' Correction of wrong GPS-reference height
      LP(Mp).Zf = LP(Mp).Zf + 0.18
    
      If Mp Mod 25 = 0 Then
       EndX = BuffX + (LP(Mp).Xs - MinPlotX) * (1 / MaximalScale)
        EndY = (BoxHeightPix - 10) - (LP(Mp).Ys - MinPlotY) * (1 / MaximalScale)
          Picture1.PSet (EndX, EndY), RGB(204, 111, 3)
      DoEvents
      End If
   Next j
   Close (1)
  
 Next k
 Form1.MousePointer = 1
 Form1.Picture1.DrawWidth = 1
 
 Label1.Caption = "Read " & Mp & " laser pulses to global memory"
 ReDim Preserve LP(1 To Mp) As ALS_Point
 Rem Let's get heights over ground i.e. normalize .Zs and .Zf to ground
 Rem Another copy of the data into LPH()
 ReDim LPH(1 To Mp) As ALS_Point_H

Label1.Caption = "Normalizing lidar heights to DTM..."
DoEvents
 
 For i = 1 To Mp
 
       LPH(i).GPS_time = LP(i).GPS_time
       LPH(i).Intf = LP(i).Intf
       LPH(i).Ints = LP(i).Ints
       LPH(i).Rangef = LP(i).Rangef
       LPH(i).Rangel = LP(i).Rangel
 '      LPH(i).Xl = LP(i).Xl
 '      LPH(i).Yl = LP(i).Yl
 '      LPH(i).Zl = LP(i).Zl
       LPH(i).Xs = LP(i).Xs
       LPH(i).Ys = LP(i).Ys
       LPH(i).Zs = LP(i).Zs
       LPH(i).Xf = LP(i).Xf
       LPH(i).Yf = LP(i).Yf
       LPH(i).Zf = LP(i).Zf
'       LPH(i).kappa = LP(i).kappa
'       LPH(i).omega = LP(i).omega
'       LPH(i).phi = LP(i).phi
       LPH(i).Scan_angle = LP(i).Scan_angle
   
    If LP(i).Zs < 0 Then MsgBox ("!")
       
       LPH(i).Hs = 0
       LPH(i).Hf = 0
   
     
   Rem Check how many actual returns we have; if less than 3 make first = last
       
   LPH(i).Hs = LPH(i).Zs - getheight(LPH(i).Xs, LPH(i).Ys)
   
   If Abs(LP(i).Rangef - LP(i).Rangel) < 3 Or Abs(LP(i).Rangef - LP(i).Rangel) > 40 Then
       LPH(i).Xf = LP(i).Xs
       LPH(i).Yf = LP(i).Ys
       LPH(i).Zf = LP(i).Zs
       LPH(i).Hf = LPH(i).Zf - getheight(LPH(i).Xf, LPH(i).Yf)
   End If
       
   If (LP(i).Rangel - LP(i).Rangef) >= 3 And (LP(i).Rangel - LP(i).Rangef) < 40 Then
       LPH(i).Hf = LPH(i).Zf - getheight(LPH(i).Xf, LPH(i).Yf)
   End If
 
       Rem Get heights above ground; some first return points have 0-values in raw data
       Rem These have negative Y-values in KKJ
 Next i
Rem Free memory; i.e. get rid of LP() -structure; make it an array with two elements
ReDim Preserve LP(1 To 2) As ALS_Point
Label1.Caption = "Ground normalized heights computed!; proceed with GRID.."
End Sub

Private Sub Read_DEM_Click()

   Close (1)
   CommonDialog1.DialogTitle = "Header file for a height model"
   CommonDialog1.Filter = "HDR files (*.hdr)|*.hdr"
   CommonDialog1.Action = 1
   DemFileName = CommonDialog1.FileName
   Open DemFileName For Input As 1

   Form1.MousePointer = 11
   DoEvents

Input #1, Zmodel.ncols
Input #1, Zmodel.nrows
Input #1, Zmodel.xllcorner
Input #1, Zmodel.yllcorner
Input #1, Zmodel.CellSize
Input #1, Zmodel.nodata_value
Input #1, Zmodel.filepath

Close (1)

ReDim ZfXY(0 To Zmodel.ncols - 1, 0 To Zmodel.nrows - 1) As Single
ReDim row(0 To Zmodel.ncols - 1) As Single

Dim place As Long

Open Zmodel.filepath For Binary As 1
For i = 0 To Zmodel.nrows - 1
 
Label1.Caption = "Reading DEM ....please wait.." & Format$(i / (Zmodel.nrows - 1) * 100, "#.0") & " % done."
DoEvents
 
 place = 1 + (i * (Zmodel.ncols)) * 4
  Get #1, place, row()
  For j = 0 To Zmodel.ncols - 1
   ZfXY(j, i) = CSng(row(j)) + 0.18
  Next j
 Next i
 Close (1)
RasterModelReady = True
Label1.Caption = " DEM read succesfully"
Form1.MousePointer = 1
DoEvents



    


End Sub
